#pragma rtGlobals=1		// Use modern global access method.



Menu "Macros"
	"-"
	"Load UC macros",LoadUC()
	//"Load NIST fitting routines", LoadNISTfittingRoutines()
	Submenu "Other Macros"
	"Load AFRL SAXS Routines", LoadAFRLSAXS()
	"Load DMA macros", LoadDMA()
	"LoadRyan ESRF Tube"
	"Load GISAXS-Lee",LoadGISAXS_lee()
	"Load NIST NG3 SANS", loadNG3_SANS()
	"Load Diffraction" ,loadDiffraction()
	"Load Size Distribution Panel", LoadDWSSizes()
	"Load ALV Light Scattering", LoadALVLightScattering()
	 "Load Digitize Graph", LoadDWSDigitize()
	 "Load Composites Panel", LoadComopositesPanel()
	 "Load OVAL tool", LoadOVAL()
	
	end
	"---"
	submenu "Remove"
	"Remove USAXS Macros", IN2_RemoveUSAXSMacros()
	"Remove Irena macros", IR1_RemoveSASMac()
	"Remove UC Macros",RemoveUCMacros()
	"Remove NIST Models",RemoveNISTFitting()
	"Remove ASAXS Macros",RemoveASAXS()
	"Remove AFRL SAXS",RemoveAFRL()
	"Remove DMA macros", RemoveDMA()
	"Remove GISAXS-Lee",RemoveGISAXS_lee()
	"Remove NG3 SANS",RemoveNG3_SANS()
	end
	"-"
end





Function RemoveUCMacros()
		Execute/P "DELETEINCLUDE \"Load UC macros\""
		Execute/P "COMPILEPROCEDURES "
end

Function RemoveNISTFitting()
	Execute/P "DELETEINCLUDE \"IN2_Load NIST fitting\""
	Execute/P "COMPILEPROCEDURES "
end

Function RemoveASAXS()
	Execute/P "DELETEINCLUDE \"ASAS_loader\""
	Execute/P "COMPILEPROCEDURES "
end



Function RemoveDMA()
	Execute/P "DELETEINCLUDE \"DMA\""
	Execute/P "COMPILEPROCEDURES "
end


Macro Pfolder()
	setdatafolder root:
	 If (!DataFolderExists("Packages"))
		Newdatafolder/O/S Packages
	endif
		setdatafolder root:Packages
	 If (!DataFolderExists("P"))
		Newdatafolder/O/S P
	endif
endmacro

Proc LoadUC()
	setdatafolder root:
	execute "Pfolder()"
	Execute/P "INSERTINCLUDE \"Load UC macros\""
		Execute/P "INSERTINCLUDE <ProcedureBrowser>"
	//openproc/V=0/P=Igor ":User Procedures:DWS User procedures:Load UC macros"
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadRyan()
	Execute/P "INSERTINCLUDE \"Ryan_code\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadDiffraction()
	Execute/P "INSERTINCLUDE \"DWS_Diffraction\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadDWSSizes()
	Execute/P "INSERTINCLUDE \"DWS_Sizes_Procedures\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadALVLightScattering()
	Execute/P "INSERTINCLUDE \"DWS_ALV_LightScattering\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadDWSDigitize()
	Execute/P "INSERTINCLUDE \"DWS_Digitizer\""
	Execute/P "COMPILEPROCEDURES "
end


	 
Proc LoadComopositesPanel()
	Execute/P "INSERTINCLUDE \"DWS_Composites\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadOVAL()
	Execute/P "INSERTINCLUDE \"DWS_OVAL_Tool\""
	Execute/P "COMPILEPROCEDURES "
end
	 

proc loadNG3_SANS()
	Execute/P "INSERTINCLUDE \"includes\""
	Execute/P "COMPILEPROCEDURES "
end

proc RemoveNG3_SANS()
	Execute/P "DELETEINCLUDE \"includes\""
	Execute/P "COMPILEPROCEDURES "
end




Proc LoadAFRLSAXS()
	execute "Pfolder()"
	Execute/P "INSERTINCLUDE \"Load UC macros\""
	Execute/P "INSERTINCLUDE \"Load AFRL\""
	Execute/P "COMPILEPROCEDURES "
end

proc LoadGISAXS_lee()
	execute "Pfolder()"
	Execute/P "INSERTINCLUDE \"GISAXSInitialize\""//"Load GISAXS\""
	Execute/P "COMPILEPROCEDURES "
end
proc RemoveGISAXS_lee()
	Execute/P "DELETEINCLUDE \"GISAXSInitialize\""
	Execute/P "COMPILEPROCEDURES "

Function RemoveAFRL()
	Execute/P "DELETEINCLUDE \"Load AFRL\""
	Execute/P "COMPILEPROCEDURES "
end

Proc LoadDMA()
	execute "Pfolder()"
	Execute/P "INSERTINCLUDE \"Load UC macros\""
	Execute/P "INSERTINCLUDE \"DMA\""
	Execute/P "COMPILEPROCEDURES "
end

